//
// Fragment shader for Image Distortion effect
//
// Author: Shirley Carter
//

uniform sampler2DRect texUnit;
uniform  vec4 modulateColor;

uniform vec4 textureRect;

varying vec2 gUV;

bool InBound(float x, float a, float b)
{
    return (x > a && x<=b);
}

bool Vec2InBound(vec2  thisVec, vec4 bounds)
{
    bool ret = InBound(thisVec.x, bounds.x, bounds.x+bounds.z) && InBound(thisVec.y, bounds.y, bounds.y+bounds.w);
    
    return ret;
}
void main(void)
{
    if ( gUV.x< textureRect.x || gUV.x> textureRect.x+textureRect.z || gUV.y < textureRect.y || gUV.y > textureRect.y+textureRect.w )
        gl_FragColor = vec4(0.0,0.0,0.0,0.0);
    else  {
        //First transform image coords i, j into x, y from 0 to 1
        float textureWidth = textureRect.z;
        float textureHeight = textureRect.w;
        
        float x =  gUV.x /textureWidth-textureRect.x/textureWidth;
        float y = gUV.y /textureHeight-textureRect.y/textureHeight;
        
        //Computer distortion
        float k  = -1.0;//-0.15; //distortion coefficient
        float kcube = .5;//.15; //cubic distortion value
        float scale = .9;
        float dispersion = .01;
        float blurAmount = .5;
        
        float r2 = (x- .5) * (x-.5) + (y - .5) * (y-.5);
        
        //compute cubic distortion, if necessary
        float mult = k;
        if( kcube != 0.0 )
        mult = k + kcube * sqrt( r2 );
        
        float f= 1.0 + r2 * mult;  //factor of distortion
        
        //chromatic aberration variable distortion depending on color
        vec2 tCoord = vec2( x, y ); //x , y coord, not image coord
        vec3 eta = vec3(1.0+dispersion*8.0, 1.0+dispersion*3.0, 1.0+dispersion*1.0);//strong red distortion, weak green and blue
        
        vec2 rCoords = (f*eta.r)*scale*(tCoord.xy-0.5)+0.5;
        vec2 gCoords = (f*eta.g)*scale*(tCoord.xy-0.5)+0.5;
        vec2 bCoords = (f*eta.b)*scale*(tCoord.xy-0.5)+0.5;
        
        if (Vec2InBound(rCoords, textureRect) && Vec2InBound(gCoords, textureRect) && Vec2InBound(bCoords, textureRect)) {
            vec2 rCoordsPrime = vec2( rCoords.x*textureWidth+textureRect.x , rCoords.y*textureHeight+textureRect.y);//transform coords back to texture coordinates
            vec2 gCoordsPrime = vec2( gCoords.x*textureWidth+textureRect.x , gCoords.y*textureHeight+textureRect.y);
            vec2 bCoordsPrime = vec2( bCoords.x*textureWidth+textureRect.x , bCoords.y*textureHeight+textureRect.y);
            
            vec3 inputDistort = vec3(0.0);
            inputDistort.r = texture2DRect(texUnit,rCoordsPrime).r;//look up color on each channel in texture
            inputDistort.g = texture2DRect(texUnit,gCoordsPrime).g;
            inputDistort.b = texture2DRect(texUnit,bCoordsPrime).b;
            
            
            gl_FragColor = modulateColor*vec4(inputDistort.r,inputDistort.g,inputDistort.b,1.0);//return color
            gl_FragColor.a = texture2DRect(texUnit, gUV).a;
        }
        else
            gl_FragColor = texture2DRect(texUnit, gUV);
    }
}

